/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.item.guns.setup;

import dev.toma.gunsrpg.api.common.IWeaponConfig;
import dev.toma.gunsrpg.common.item.guns.ammo.AmmoType;
import dev.toma.gunsrpg.common.item.guns.setup.MaterialContainer;
import dev.toma.gunsrpg.common.item.guns.setup.MaterialContainerBuilder;
import dev.toma.gunsrpg.common.item.guns.setup.WeaponCategory;
import dev.toma.gunsrpg.common.item.guns.util.Firemode;
import java.util.Objects;
import java.util.function.BiFunction;
import net.minecraft.entity.player.PlayerEntity;

public final class WeaponBuilder {
    private WeaponCategory category;
    private IWeaponConfig config;
    private MaterialContainer container;
    private AmmoType ammoType;
    private BiFunction<PlayerEntity, Firemode, Firemode> firemodeSelector = (player, firemode) -> firemode;

    public WeaponBuilder category(WeaponCategory category) {
        this.category = category;
        return this;
    }

    public WeaponBuilder caliber(AmmoType type) {
        this.ammoType = type;
        return this;
    }

    public WeaponBuilder config(IWeaponConfig config) {
        this.config = config;
        return this;
    }

    public WeaponBuilder firemodeSelector(BiFunction<PlayerEntity, Firemode, Firemode> firemodeSelector) {
        this.firemodeSelector = Objects.requireNonNull(firemodeSelector);
        return this;
    }

    public MaterialContainerBuilder ammo() {
        return new MaterialContainerBuilder(this);
    }

    public MaterialContainerBuilder ammo(WeaponCategory category) {
        this.category(category);
        return this.ammo();
    }

    WeaponBuilder materialContainer(MaterialContainer container) {
        this.container = container;
        return this;
    }

    public WeaponCategory getWeaponCategory() {
        return this.category;
    }

    public IWeaponConfig getConfig() {
        return this.config;
    }

    public MaterialContainer getMaterialContainer() {
        return this.container;
    }

    public AmmoType getAmmoType() {
        return this.ammoType;
    }

    public BiFunction<PlayerEntity, Firemode, Firemode> getFiremodeSelector() {
        return this.firemodeSelector;
    }

    public void validate() {
        Objects.requireNonNull(this.category, "Weapon category is undefined!");
        if (this.ammoType == null) {
            this.ammoType = this.category.getDefaultAmmoType();
        }
    }
}

